package emps.v2_obiektowo;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/* W tej wersji używamy operacji getOrDefault (od Java 8) - dzięki temu można nie pisać ifa. */

public class Grupowanie_v3 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new TreeMap<>();
        Map<String, Integer> ilosci = new TreeMap<>();
        for(Employee emp : emps) {
            int suma = sumy.getOrDefault(emp.getJobTitle(), 0);
            sumy.put(emp.getJobTitle(), suma + emp.getSalary());
            int ilosc = ilosci.getOrDefault(emp.getJobTitle(), 0);
            ilosci.put(emp.getJobTitle(), ilosc + 1);
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
