package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/* Klasyczny algorytm grupowania w oparciu o słowniki.
 * W tej wersji wykorzystujemy tylko operacje get, put, containsKey, które są dostępne od samego początku istnienia słowników Javie.
 */

public class Grupowanie_v2a {

    public static void main(String[] args) {
        final List<Employee> emps = ObslugaCSV.wczytajDane();
        final Map<String, Integer> sumy = new HashMap<>();
        final Map<String, Integer> ilosci = new HashMap<>();
        for(Employee emp : emps) {
            final String jobTitle = emp.getJobTitle();
            if(sumy.containsKey(jobTitle)) {
                sumy.put(jobTitle, sumy.get(jobTitle) + emp.getSalary());
                ilosci.put(jobTitle, ilosci.get(jobTitle) + 1);
            } else {
                sumy.put(jobTitle, emp.getSalary());
                ilosci.put(jobTitle, 1);
            }
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
