package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/* Klasyczny algorytm grupowania w oparciu o słowniki.
 * W tej wersji wykorzystujemy tylko operacje get, put, containsKey, które są dostępne od samego początku istnienia słowników Javie.
 */

public class Grupowanie_v2 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new HashMap<>();
        Map<String, Integer> ilosci = new HashMap<>();
        for(Employee emp : emps) {
            // sprawdzamy, czy słownik już zawiera wpis dotyczący tego joba
            if(sumy.containsKey(emp.getJobTitle())) {
                // to jest kolejny pracownik z tego stanowiska → trzeba zwiększyć sumę
                int suma = sumy.get(emp.getJobTitle());
                sumy.put(emp.getJobTitle(), suma + emp.getSalary());
                int ilosc = ilosci.get(emp.getJobTitle());
                ilosci.put(emp.getJobTitle(), ilosc + 1);
            } else {
                // to jest pierwszy pracownik z tego stanowiska
                sumy.put(emp.getJobTitle(), emp.getSalary());
                ilosci.put(emp.getJobTitle(), 1);
            }
        }
//        System.out.println(sumy);
//        System.out.println(ilosci);
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
