package emps.v2_obiektowo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/* W tej wersji:
   złożoność obliczeniowa nie jest optymalna. Cała lista jest przeglądana wiele razy:
   - raz, aby ustalić zbiór jobów,
   - ponownie dla każdego joba.
   Dla naszego pliku to jest (1+19) * 107 powtórzeń.
 */
public class Grupowanie_v1 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        // etap 1: utworzenie zbioru jobów (bez powtórzeń)
        Set<String> jobs = new HashSet<>();
        for(Employee emp : emps) {
            jobs.add(emp.getJobTitle());
        }
        // System.out.println(jobs);
        
        // etap 2: dla każdego z tych jobów liczymy (za pomocą pętli i ifa) średnią dla tego joba:
        for(String job : jobs) {
            double suma = 0;
            int ile = 0;
            for(Employee emp : emps) {
                if(emp.getJobTitle().equals(job)) {
                    suma += emp.getSalary();
                    ile++;
                }
            }
            double srednia = suma / ile;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
        }
    }

}
