package emps.v2_obiektowo;

import java.util.List;

public class Grupowanie_Switch {
	// Ta wersja tylko jako wprowadzenie do wersji ze słownikami.
	// Gdybyśmy dla każdego joba mieli oddzielną zmienną do liczenia sumy,
	// moglibyśmy wszystko policzyć w jednej pętli.
	
	// Problem:
	// 1) program powinien czytać dowolne dane; nie powinien z góry zakładać, jakie są joby
	// 2) każdy nowy job zwiększa ilość kodu.
	
	// → jesli zamiast oddzielnych zmiennych użyjemy jednego słownika, to zrobimy to samo, ale zwięźlej
	// słownik (Map) z kluczami typu String może być traktowany jako namiasta zestawu zmiennych,
	// który możemy łatwo rozszerzać gdy pojawiają się nowe wartości
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytajDane();
		
		double sumaProgrammer = 0;
		double sumaAccountant = 0;
		double sumaPresident = 0;
		// itd....
		
		for (Employee emp : emps) {
			switch(emp.getJobTitle()) {
			case "Programmer" -> sumaProgrammer += emp.getSalary();
			case "Accountant" -> sumaAccountant += emp.getSalary();
			case "President" -> sumaPresident += emp.getSalary();
			}
		}
		
		System.out.println(sumaProgrammer);
		System.out.println(sumaAccountant);
		System.out.println(sumaPresident);
		
	}

}
