package emps.v2_obiektowo;

import java.time.LocalDate;
import java.util.Objects;

public class Employee {
    private int employeeId;
    private String firstName;
    private String lastName;
    private String jobTitle;
    private int salary;
    private LocalDate hireDate;
    private String departmentName;
    private String address;
    private String postalCode;
    private String city;
    private String country;
    
    public Employee(int employeeId, String firstName, String lastName, String jobTitle, int salary, LocalDate hireDate,
            String departmentName, String address, String postalCode, String city, String country) {
        this.employeeId = employeeId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.jobTitle = jobTitle;
        this.salary = salary;
        this.hireDate = hireDate;
        this.departmentName = departmentName;
        this.address = address;
        this.postalCode = postalCode;
        this.city = city;
        this.country = country;
    }

    public int getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(int employeeId) {
        this.employeeId = employeeId;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public int getSalary() {
        return salary;
    }

    public void setSalary(int salary) {
        this.salary = salary;
    }

    public LocalDate getHireDate() {
        return hireDate;
    }

    public void setHireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String toString() {
        return "Employee [employeeId=" + employeeId + ", firstName=" + firstName + ", lastName=" + lastName
                + ", jobTitle=" + jobTitle + ", salary=" + salary + ", hireDate=" + hireDate + ", departmentName="
                + departmentName + ", address=" + address + ", postalCode=" + postalCode + ", city=" + city
                + ", country=" + country + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(address, city, country, departmentName, employeeId, firstName, hireDate, jobTitle, lastName, postalCode, salary);
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(getClass() != obj.getClass())
            return false;
        Employee other = (Employee) obj;
        return Objects.equals(address, other.address) && Objects.equals(city, other.city)
                && Objects.equals(country, other.country) && Objects.equals(departmentName, other.departmentName)
                && employeeId == other.employeeId && Objects.equals(firstName, other.firstName)
                && Objects.equals(hireDate, other.hireDate) && Objects.equals(jobTitle, other.jobTitle)
                && Objects.equals(lastName, other.lastName) && Objects.equals(postalCode, other.postalCode)
                && salary == other.salary;
    }

}
