package p30_swing.rysowanie;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Rysowanie2D {
	private JFrame okno;
	private PanelRysujacy panel;
	
	public void przygotujIWyswietl() {
		przygotujWyglad();
		ustawZdarzenia();
		dzialaj();
	}


	private void przygotujWyglad() {
		okno = new JFrame("Rysowanie");
		okno.setSize(800, 800);
		
		BoxLayout layout = new BoxLayout(okno.getContentPane(), BoxLayout.Y_AXIS);
		okno.setLayout(layout);

		panel = new PanelRysujacy();
		okno.add(panel);
		
	}

	private void ustawZdarzenia() {
		
	}

	private void dzialaj() {
		okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		okno.setVisible(true);		
	}


	public static void main(String[] args) {
		new Rysowanie2D().przygotujIWyswietl();
	}
	
	private static class PanelRysujacy extends JPanel {
		private int licznik = 0;
		
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);
			
			if(g instanceof Graphics2D) {
				Graphics2D g2 = (Graphics2D)g;
				
				AffineTransform pustyTrans = g2.getTransform();
				
				g2.setColor(Color.PINK);
				g2.fillRect(50, 50, 100, 200);
				
				// filtr przez ktory przechodza wszystkie polecenia ponizej
				g2.rotate(Math.PI / 4, 200, 200);
				g2.setColor(Color.GREEN);
				g2.fillRect(50, 50, 100, 200);
				
				g2.setColor(Color.YELLOW);
				g2.fill3DRect(300, 200, 50, 50, true);
				
				g2.setTransform(pustyTrans);
				
				g2.setColor(Color.RED);
				g2.fillArc(300, 300, 100, 100, 0, 30);
				g2.setColor(Color.BLUE);
				g2.fillArc(300, 300, 100, 100, 30, 130);
				g2.setColor(Color.GREEN);
				g2.fillArc(300, 300, 100, 100, 160, 200);
			}
		}
	}
}