package p12_kolekcje.zbieranie_danych;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

// Słowniki (mapy):
// - zawierają pary klucz → wartość
// - klucze nie mogą się powtarzać, wartości mogą
// - wydajne są operacje dodawanie elementu i pobierania/wyszukiwania poprzez klucz
// - niewydaje jest wyszukiwanie poprzez wartość

public class P5_HashMap {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // w tym przykładzie dla imienia osoby pamiętamy wiek tej osoby
        Map<String, Integer> slownik = new HashMap<>();
        
        while(true) {
            System.out.print("Podaj imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            System.out.print("Podaj wiek: ");
            int wiek = scanner.nextInt();
            scanner.nextLine();
            slownik.put(imie, wiek);
        }
        
        System.out.println("Liczba elementów: " + slownik.size());
        System.out.println("Cały słownik: " + slownik);
        System.out.println();
        
        // Podstawowa operacja odczytu dla słownika to odczyt wartości z miejsca wskazanego kluczem.
        System.out.println("Podawaj imiona. Aby zakończyć, podaj pusty napis.");
        while(true) {
            System.out.print("imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            Integer wiek = slownik.get(imie);
            if(wiek == null) {
                System.out.println("Nie znam takiej osoby");
            } else {
                System.out.println("Osoba " + imie + " ma " + wiek + " lat.");
            }
        }
        System.out.println("KONIEC");
    }

}
