package p12_kolekcje.zbieranie_danych;

import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

// Zbiory:
// - nie zawierają duplikatów (dodanie kolejny raz tej samej wartości nie zmienia już zbioru),
// - mają prawo zmienić kolejność elementów
//   → HashSet zmienia kolejność
//   → LinkedHashSet nie zmienia kolejności (zachowuje początkową kolejność, w jakiej elementy były dodawane)
//   → TreeSet samoczynnie sortuje elementy
// Podstawową (i wydajną) operacją dla zbioru jest sprawdzenie czy element należy do zbioru.

public class P3_HashSet {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        Set<String> zbior = new HashSet<>();
        
        while(true) {
            System.out.print("Podaj imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            zbior.add(imie);
        }
        
        System.out.println("Liczba elementów: " + zbior.size());
        System.out.println("Cały zbiór: " + zbior);
        System.out.println();
        
        // Podstawowa operacja odczytu dla zbioru (poza pętlą for-each) to sprawdzenie, czy wartość należy do zbioru.
        System.out.println("Podawaj imiona, aby sprawdzić, czy należą do zbioru. Aby zakończyć, podaj pusty napis.");
        while(true) {
            System.out.print("imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            if(zbior.contains(imie)) {
                System.out.println("Imię " + imie + " należy do zbioru.");
            } else {
                System.out.println("Imię " + imie + " NIE należy do zbioru.");
            }
        }
        System.out.println("KONIEC");
    }

}
