package p12_kolekcje.zbieranie_danych;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

// Listy:
// - mogą zawierać duplikaty (tę wartość kilka razy),
// - przechowują elementy na określonych pozycjach od 0 do size-1,
//   za pomocą get(i) można odczytać, a za pomocą set(i, nowaWartosc) zmienić konkretny element listy
public class P2_Lista {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        List<String> lista = new ArrayList<>();
        
        while(true) {
            System.out.print("Podaj imię: ");
            String imie = scanner.nextLine();
            if(imie.isEmpty()) break;
            lista.add(imie);
        }
        
        System.out.println("Liczba elementów: " + lista.size());
        System.out.println("Cała lista: " + lista);
        System.out.println();
        
        // Podstawowa operacja odczytu z listy (poza pętlą for-each) to odczyt z określonej pozycji, podobnie jak dla tablic.
        // Dla list używa się metody get(i)
        System.out.println("Podawaj liczby - numery pozycji. Aby zakończyć, wpisz -1");
        while(true) {
            System.out.print("nr: ");
            int nr = scanner.nextInt();
            if(nr == -1) break;
            try {
                System.out.printf("Imię nr %d = %s\n", nr, lista.get(nr));
            } catch (IndexOutOfBoundsException e) {
                System.out.println("błąd! " + e);
            }
        }
        System.out.println("KONIEC");
    }

}
