package emps.v2_obiektowo;

import java.util.Comparator;
import java.util.List;

public class P6_Sortowanie_v3 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        System.out.println("Sortujemy rosnąco wg pensji");
        
        // Sortujemy rosnąco wg miast, a w obrębie każdego miasta malejąco wg pensji
        emps.sort(Comparator
                .comparing(Employee::getCity)
                .reversed()
                .thenComparingInt(Employee::getSalary)
                .reversed());
        
        for(Employee emp : emps) {
            System.out.printf("%s %s (%s) z miasta %s zarabia %d\n",
                    emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getCity(), emp.getSalary());
        }
    }

}
