package przyklady;

import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import model.Employee;

public class OdczytajManagerow {

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("hr");
			em = emf.createEntityManager();
		
			while(true) {
				System.out.print("\nPodaj id pracownika: ");
				if(!sc.hasNextInt())
					break;
				int id = sc.nextInt();
				Employee emp = em.find(Employee.class, id);
				
				if(emp == null) {
					System.out.println("nie znaleziono takiego pracownika");
					continue;
				}
				
				while(emp != null) {
					System.out.println("    " + emp.getEmployeeId() + " " + emp.getFirstName() + " " + emp.getLastName()
						+ "(" + emp.getJob().getJobTitle() + ")" + " $" + emp.getSalary());
					emp = emp.getManager();
					System.out.println("Managerem jest:");
				}
			}
		} finally {
			if(em != null)
				em.close();
			if(emf != null)
				emf.close();
		}
	}
}
