package bazy.podstawy;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Scanner;

public class Podwyzka1 {

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/hr", "kurs", "abc123")) {
			// połączenie inicjalnie jest w trybie "auto commit", czyli każda zmiana jest od razu zapisywana w sposób trwały w bazie danych
			System.out.print("Podaj job_id: ");
			String job = sc.nextLine();

			System.out.print("Podaj kwotę podwyżki: ");
			BigDecimal kwota = sc.nextBigDecimal();

			final String sql = "UPDATE employees SET salary = salary + ? WHERE job_id = ?";
			try(PreparedStatement stmt = c.prepareStatement(sql)) {
				stmt.setBigDecimal(1, kwota);
				stmt.setString(2, job);
				int ile = stmt.executeUpdate();
				System.out.println("Zmodyfikowano " + ile + " rekordów.");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
