package sklep.soap;

import java.math.BigDecimal;
import java.util.List;

import jakarta.jws.WebService;
import jakarta.xml.ws.soap.MTOM;
import sklep.db.CustomerDAO;
import sklep.db.DBConnection;
import sklep.db.OrderDAO;
import sklep.db.ProductDAO;
import sklep.exn.DBException;
import sklep.exn.RecordNotFound;
import sklep.model.Customer;
import sklep.model.Order;
import sklep.model.Product;
import sklep.photo.PhotoUtil;

@WebService(endpointInterface="sklep.soap.Sklep")
@MTOM
public class SklepImpl implements Sklep {
	public List<Product> wszystkieProdukty() throws DBException {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			return productDAO.readAll();
		}
	}
	
	public Product produktWgId(int productId) throws DBException, RecordNotFound {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			return productDAO.findById(productId);
		}
	}
	
	public List<Product> produktyWgCen(
			BigDecimal minPrice,
			BigDecimal maxPrice) throws DBException {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			return productDAO.findByPrice(minPrice, maxPrice);
		}
	}
	
	public void zapiszProdukt(Product product) throws DBException {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			productDAO.save(product);
			db.commit();
		}
	}
	
	public Order zamowienieWgId(int orderId) throws DBException, RecordNotFound {
		try(DBConnection db = DBConnection.open()) {
			OrderDAO orderDAO = db.orderDAO();
			return orderDAO.findById(orderId);
		}
	}
	
	public Customer klient(String email) throws DBException, RecordNotFound {
		try(DBConnection db = DBConnection.open()) {
			CustomerDAO customerDAO = db.customerDAO();
			return customerDAO.findByEmail(email);
		}
	}
	
	public byte[] foto(int productId) throws DBException, RecordNotFound {
		return PhotoUtil.readBytes(productId);
	}
	
}
