package sklep.soap;

import java.math.BigDecimal;
import java.util.List;

import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import sklep.exn.DBException;
import sklep.exn.RecordNotFound;
import sklep.model.Customer;
import sklep.model.Order;
import sklep.model.Product;

// Na taki interfejs mówi się "service endpoint interface" (SEI)
@WebService
public interface Sklep {
	@WebResult(name="product")
	List<Product> wszystkieProdukty() throws DBException;

	@WebResult(name="product")
	Product produktWgId(@WebParam(name="id") int productId) throws DBException, RecordNotFound;

	@WebResult(name="product")
	List<Product> produktyWgCen(
			@WebParam(name="min") BigDecimal minPrice,
			@WebParam(name="max") BigDecimal maxPrice) throws DBException;

	void zapiszProdukt(@WebParam(name="product") Product product) throws DBException;

	@WebResult(name="order")
	Order zamowienieWgId(@WebParam(name="id") int orderId) throws DBException, RecordNotFound;

	@WebResult(name="customer")
	Customer klient(@WebParam(name="email") String email) throws DBException, RecordNotFound;

	@WebResult(name="bytes")
	byte[] foto(@WebParam(name="id") int productId) throws DBException, RecordNotFound;

}