package sklep.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

import sklep.db.DBConnection;
import sklep.db.ProductDAO;
import sklep.exn.DBException;
import sklep.exn.RecordNotFound;
import sklep.model.Product;
import sklep.model.ProductList;

@Path("/products.pdf")
@Produces("application/pdf")
public class RProductPDF {

	@GET
	public ProductList readAllProducts() throws DBException {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			return new ProductList(productDAO.readAll());
		}
	}

	@Path("/{id}")
	@GET
	public Product readOneProduct(@PathParam("id") int productId) throws DBException, RecordNotFound {
		try(DBConnection db = DBConnection.open()) {
			ProductDAO productDAO = db.productDAO();
			return productDAO.findById(productId);
		}
	}	
}
