package sklep.klient_rest;

import java.util.List;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import sklep.model.Product;
import sklep.model.ProductList;

public class P08_RestClient_JSON_Lista {

	public static void main(String[] args) {
		Client client = ClientBuilder.newClient();
		
		Response response = client.target(Ustawienia.ADRES_USLUGI)
			.path("products.json")
			.request().buildGet()
			.invoke();
		
		System.out.println("Mam odpowiedź: " + response);
		System.out.println("Status: " + response.getStatus());
		System.out.println("C-Type: " + response.getMediaType());
		System.out.println("Length: " + response.getLength());
		
		GenericType<List<Product>> typListy = new GenericType<List<Product>>() {};
		 
		List<Product> products = response.readEntity(typListy);
		for(Product product : products) {
			System.out.println(product);
		}
	}

}
