package sklep.klient_rest;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;

public class P03_HttpClient {

	public static void main(String[] args) {
		HttpClient httpClient = HttpClient.newHttpClient();
		try {
			URI uri = new URI(Ustawienia.ADRES_USLUGI + "/products.json");
			HttpRequest request = HttpRequest.newBuilder(uri).build();
			HttpResponse<String> response = httpClient.send(request, BodyHandlers.ofString());
			System.out.println("response " + response);
			System.out.println("status: " + response.statusCode());
			System.out.println("Content-Type: " + response.headers().firstValue("Content-Type").orElse("BRAK"));
			
			String body = response.body();
			System.out.println("Rozmiar treści: " + body.length());
			System.out.println("\nCała treść:\n");
			System.out.println(body);
		} catch (URISyntaxException | IOException | InterruptedException e) {
			e.printStackTrace();
		}

	}

}
