package sklep.model;

import java.time.LocalDateTime;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

public class LocalDateTimeAdapter extends XmlAdapter<String, LocalDateTime> {

	@Override
	public LocalDateTime unmarshal(String s) throws Exception {
		return LocalDateTime.parse(s);
	}

	@Override
	public String marshal(LocalDateTime dt) throws Exception {
		return dt.toString();
	}

}
