package com.demo.sklep.rest;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

import com.demo.sklep.model.Order;
import com.demo.sklep.repository.OrderRepository;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

@Path("/orders")
@Produces("application/json")
@Consumes("application/json")
public class ROrder {
    @Autowired
    private OrderRepository orderRepository;
    
    @GET
    public List<Order> readAll() {
        return orderRepository.findAll();
    }
    
    @Path("/{id}")
    @GET
    public Order readOne(@PathParam("id") int id) {
        Optional<Order> order = orderRepository.findById(id);
        if(order.isPresent()) {
            return order.get();
        } else {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Nie ma zamówienia o numerze " + id);
        }
    }
        
}
