package com.demo.sklep.repository;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import com.demo.sklep.model.Product;

@Repository
public interface ProductRepository extends JpaRepository<Product, Integer> {

	List<Product> findByProductName(String name);

	List<Product> findByProductNameContaining(String name);

	List<Product> findByProductNameContainingIgnoringCase(String name);
	
	List<Product> findByPriceBetween(BigDecimal min, BigDecimal max);

	List<Product> findByProductNameContainingIgnoringCaseAndPriceBetween(String name, BigDecimal min, BigDecimal max);

}
