package rest;

import java.util.concurrent.atomic.AtomicInteger;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;

@Path("/sesja")
public class Sesja {
	@Context
	private HttpServletRequest request;

	@Produces("text/plain")
	@GET
	public int licznik() {
		HttpSession sesja = request.getSession();
		AtomicInteger licznik = null;
		synchronized (sesja) {			
			licznik = (AtomicInteger) sesja.getAttribute("x");
			if(licznik == null) {
				licznik = new AtomicInteger(100);
				sesja.setAttribute("x", licznik);
				sesja.setMaxInactiveInterval(30); // po 30s sesja wygasa
			}
		}	
		return licznik.getAndIncrement();
		// tak jakby return licznik++
	}
}
