package sklep.rest.ext;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Response.Status;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import sklep.db.SklepException;

@Provider
public class SklepExceptionMapper implements ExceptionMapper<SklepException> {

	@Override
	public Response toResponse(SklepException e) {
		String tresc = String.format("<html><body>"
				+ "<h1>Błąd</h1>"
				+ "<div>Błąd typu <code>%s</code></div>"
				+ "<div style='color:red'>%s</div>"
				+ "</body></html>",
				e.getClass().getName(),
				e.getMessage());
		
		return Response.status(Status.INTERNAL_SERVER_ERROR)
				.type("text/html;charset=utf-8")
				.entity(tresc)
				.build();
	}

}

// a gdybyśmy chcieli mapować wszystkie wyjątki
// public class DefaultExceptionMapper implements ExceptionMapper<Exception> { ... }
