package sklep.klient;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import sklep.generated.*;

public class OknoSoap {
	private Sklep proxy;
	private JFrame frame;
	private JTextField txtTytul;
	private JTextField txtMarka;
	private JTextField txtCena;
	private JSpinner spinner;
	private JLabel lblFoto;
	private Product biezacyProdukt;
	private ImageIcon ikonaZeZdjeciem;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					OknoSoap window = new OknoSoap();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public OknoSoap() {
		SklepService serwis = new SklepService();
		proxy = serwis.getSklepPort();
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBounds(100, 100, 841, 801);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		spinner = new JSpinner();
		spinner.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				wyswietl();
			}
		});
		spinner.setFont(new Font("Dialog", Font.BOLD, 22));
		
		JLabel lblPodajIdOgoszenia = new JLabel("Podaj ID ogłoszenia");
		lblPodajIdOgoszenia.setFont(new Font("Dialog", Font.PLAIN, 20));
		
		JButton btnWywietl = new JButton("Wyświetl");
		btnWywietl.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ev) {
				wyswietl();
			}
		});
		btnWywietl.setFont(new Font("Dialog", Font.BOLD, 20));
		
		JPanel panel = new JPanel();
		
		lblFoto = new JLabel("FOTO");
		GroupLayout groupLayout = new GroupLayout(frame.getContentPane());
		groupLayout.setHorizontalGroup(
			groupLayout.createParallelGroup(Alignment.TRAILING)
				.addGroup(groupLayout.createSequentialGroup()
					.addContainerGap()
					.addGroup(groupLayout.createParallelGroup(Alignment.LEADING)
						.addComponent(lblFoto, GroupLayout.DEFAULT_SIZE, 817, Short.MAX_VALUE)
						.addGroup(groupLayout.createSequentialGroup()
							.addComponent(lblPodajIdOgoszenia)
							.addPreferredGap(ComponentPlacement.UNRELATED)
							.addComponent(spinner, GroupLayout.PREFERRED_SIZE, 72, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, 437, Short.MAX_VALUE)
							.addComponent(btnWywietl))
						.addComponent(panel, GroupLayout.DEFAULT_SIZE, 817, Short.MAX_VALUE))
					.addContainerGap())
		);
		groupLayout.setVerticalGroup(
			groupLayout.createParallelGroup(Alignment.LEADING)
				.addGroup(groupLayout.createSequentialGroup()
					.addContainerGap()
					.addGroup(groupLayout.createParallelGroup(Alignment.TRAILING)
						.addGroup(groupLayout.createSequentialGroup()
							.addGroup(groupLayout.createParallelGroup(Alignment.BASELINE)
								.addComponent(lblPodajIdOgoszenia)
								.addComponent(spinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
							.addGap(20))
						.addGroup(groupLayout.createSequentialGroup()
							.addComponent(btnWywietl)
							.addPreferredGap(ComponentPlacement.UNRELATED)))
					.addComponent(panel, GroupLayout.PREFERRED_SIZE, 155, GroupLayout.PREFERRED_SIZE)
					.addGap(18)
					.addComponent(lblFoto, GroupLayout.DEFAULT_SIZE, 523, Short.MAX_VALUE)
					.addContainerGap())
		);
		
		JLabel lblTytu = new JLabel("Nazwa");
		lblTytu.setFont(new Font("Dialog", Font.PLAIN, 18));
		
		txtTytul = new JTextField();
		txtTytul.setFont(new Font("Dialog", Font.BOLD, 16));
		txtTytul.setColumns(10);
		
		JLabel lblMarka = new JLabel("Opis");
		lblMarka.setFont(new Font("Dialog", Font.PLAIN, 18));
		
		txtMarka = new JTextField();
		txtMarka.setFont(new Font("Dialog", Font.BOLD, 16));
		txtMarka.setColumns(10);
		
		JLabel lblCena = new JLabel("Cena");
		lblCena.setFont(new Font("Dialog", Font.PLAIN, 18));
		
		txtCena = new JTextField();
		txtCena.setFont(new Font("Dialog", Font.BOLD, 16));
		txtCena.setColumns(10);
		GroupLayout gl_panel = new GroupLayout(panel);
		gl_panel.setHorizontalGroup(
			gl_panel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panel.createSequentialGroup()
					.addContainerGap()
					.addGroup(gl_panel.createParallelGroup(Alignment.LEADING)
						.addGroup(gl_panel.createSequentialGroup()
							.addGroup(gl_panel.createParallelGroup(Alignment.TRAILING, false)
								.addComponent(lblMarka, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addComponent(lblTytu, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 152, Short.MAX_VALUE))
							.addPreferredGap(ComponentPlacement.UNRELATED)
							.addGroup(gl_panel.createParallelGroup(Alignment.LEADING)
								.addComponent(txtMarka, GroupLayout.DEFAULT_SIZE, 623, Short.MAX_VALUE)
								.addComponent(txtTytul, GroupLayout.DEFAULT_SIZE, 623, Short.MAX_VALUE)))
						.addGroup(Alignment.TRAILING, gl_panel.createSequentialGroup()
							.addComponent(lblCena)
							.addGap(128)
							.addComponent(txtCena, GroupLayout.DEFAULT_SIZE, 623, Short.MAX_VALUE)))
					.addContainerGap())
		);
		gl_panel.setVerticalGroup(
			gl_panel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panel.createSequentialGroup()
					.addContainerGap()
					.addGroup(gl_panel.createParallelGroup(Alignment.BASELINE)
						.addComponent(lblTytu)
						.addComponent(txtTytul, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addGroup(gl_panel.createParallelGroup(Alignment.BASELINE)
						.addComponent(lblMarka)
						.addComponent(txtMarka, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addGap(18)
					.addGroup(gl_panel.createParallelGroup(Alignment.BASELINE)
						.addComponent(txtCena, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblCena))
					.addContainerGap(44, Short.MAX_VALUE))
		);
		panel.setLayout(gl_panel);
		frame.getContentPane().setLayout(groupLayout);
	}

	// jest wywoływane przez Swinga po kliknięciu guzika itp.
	// ta metoda jest wykonywana w wątku EDT
	protected void wyswietl() {
		int idOgloszenia = (Integer)spinner.getValue();
		
		SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>() {
			@Override
			protected Void doInBackground() throws Exception {
				// to wykona się w oddzielnym wątku,
				// nie zablokuj okna, ale tutaj nie powinniśmy korzystać z elementów okna
				pobierzDane(idOgloszenia);
				return null;
			}
			
			@Override
			protected void done() {
				// tu powinniśmy wpisać polecenia dotyczące okna, które mają być wykonane przez EDT po zakończeniu operacji
				uaktualnijWidok();
			}
		};
		worker.execute();
	}

	private void pobierzDane(int id) {
		// ma być wykonane w tle
		try {
			ikonaZeZdjeciem = null;
			biezacyProdukt = null;
			biezacyProdukt = proxy.produktWgId(id);
			try {
				byte[] bajtyZeZdjeciem = proxy.foto(id);
				if(bajtyZeZdjeciem != null) {
					ikonaZeZdjeciem = new ImageIcon(bajtyZeZdjeciem);
				}
			} catch (RecordNotFound_Exception e) {
				// zdjecie zostaje nullem
			}
		} catch (DBException_Exception e) {
			e.printStackTrace();
		} catch (RecordNotFound_Exception e) {
		}
	}
	
	private void uaktualnijWidok() {
		// ma być wykonane przez okno (czyli wątek EDT)
		if(biezacyProdukt != null) {
			txtTytul.setText(biezacyProdukt.getProductName());
			txtMarka.setText(biezacyProdukt.getDescription());
			txtCena.setText(String.valueOf(biezacyProdukt.getPrice()));
		} else {
			txtTytul.setText("");
			txtMarka.setText("");
			txtCena.setText("");			
		}
		lblFoto.setIcon(ikonaZeZdjeciem);
	}
}
