package sklep.klient;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Scanner;

import sklep.generated.DBException_Exception;
import sklep.generated.Product;
import sklep.generated.RecordNotFound_Exception;
import sklep.generated.Sklep;
import sklep.generated.SklepService;

public class Klient3 {

	public static void main(String[] args) {
		Scanner scanner = new Scanner(System.in);
		scanner.useLocale(Locale.US);
		SklepService service = new SklepService();
		Sklep sklep = service.getSklepPort();
		
		while(true) {
			System.out.println("Podaj ID produktu lub 0, aby zakończyć");
			int id = scanner.nextInt();
			if(id == 0) break;
			try {
				Product product = sklep.produktWgId(id);
				System.out.println("Znaleziono produkt: " + product.getProductName() + " za cenę " + product.getPrice());
				if(product.getDescription() != null) {
					System.out.println("Opis: " + product.getDescription());
				}

				boolean czyCosSieZmienilo = false;
				System.out.println("Podaj zmianę ceny: ");
				BigDecimal zmiana = scanner.nextBigDecimal();
				if(zmiana.compareTo(BigDecimal.ZERO) != 0) {
					product.setPrice(product.getPrice().add(zmiana));
					czyCosSieZmienilo = true;
				}
				
				scanner.nextLine();
				System.out.println("Podaj nową nazwę (enter, aby nie zmieniać): ");
				String nazwa = scanner.nextLine();
				if(!nazwa.isEmpty()) {
					product.setProductName(nazwa);
					czyCosSieZmienilo = true;
				}
				System.out.println("Podaj nowy opis (enter, aby nie zmieniać): ");
				String opis = scanner.nextLine();
				if(!opis.isEmpty()) {
					product.setDescription(opis);
					czyCosSieZmienilo = true;
				}				
				if(czyCosSieZmienilo) {
					sklep.zapiszProdukt(product);
					System.out.println("Zapisano zmiany");
				}
				System.out.println();
			} catch (RecordNotFound_Exception e) {
				System.out.println("Nie ma takiego rekordu");
			} catch (DBException_Exception e) {
				System.out.println("Inny błąd: " + e);
				e.printStackTrace();
			}
		}
	}

}
