package hello;

import java.time.LocalDateTime;

import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;

@WebService
public class Usluga {
	
	public String helloWorld() {
		return "Hello world";
	}
	
	@WebResult(name="powitanie")
	public String witaj(@WebParam(name="imie") String imie) {
		return "Witaj " + imie;
	}

	@WebResult(name="data-i-czas")
	public String ktoraGodzina() {
		return LocalDateTime.now().toString();
	}
	
	@WebResult(name="wynik")
	public int oblicz(
			@WebParam(name="liczba1") int x,
			@WebParam(name="liczba2") int y,
			@WebParam(name="operacja") String operacja) {
		return switch (operacja) {
			case "+" -> x + y;
			case "-" -> x - y;
			case "*" -> x * y;
			case "/" -> x / y;
			default-> throw new IllegalArgumentException("Nieznana operacja " + operacja);
		};
	}
	
}
