package sklep.przyklady;

import java.util.List;

import jakarta.persistence.*;

import sklep.model.Product;

public class OdczytajWszystko_JPQL {

	public static void main(String[] args) {
		// JPQL - Java (Jakarta) Persistence Query Language
		
		EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("sklep");
            em = emf.createEntityManager();
            
            TypedQuery<Product> query = em.createQuery("SELECT p FROM Product p ORDER BY p.productId", Product.class);
            List<Product> products = query.getResultList();
            for(Product product : products) {
				// System.out.println(product);
				System.out.println(product.getProductName() + " za cenę " + product.getPrice());
			}
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            if(em != null)
                em.close();
            if(emf != null)
                emf.close();
        }
	}

}
