package nowe_przyklady;

import java.math.BigDecimal;
import java.math.RoundingMode;

import hr.model.Employee;
import sklep.model.Product;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

public class DwieBazyNaRaz {

	public static void main(String[] args) {
		try(EntityManagerFactory sklep_emf = Persistence.createEntityManagerFactory("sklep");
			EntityManagerFactory hr_emf = Persistence.createEntityManagerFactory("hr");
			EntityManager sklep_em = sklep_emf.createEntityManager();
			EntityManager hr_em = hr_emf.createEntityManager()) {
			
			System.out.println("Oba managery gotowe");
			
			int employeeId = 100;
			int productId = 1;
			
			Employee employee = hr_em.find(Employee.class, employeeId);
			Product product = sklep_em.find(Product.class, productId);
			BigDecimal ilosc = employee.getSalary().divide(product.getPrice(), 1, RoundingMode.HALF_UP);
			
			System.out.printf("Pracownik %s %s zarabia %s i może kupić %s sztuk produktu %s\n.",
					employee.getFirstName(), employee.getLastName(), employee.getSalary(), ilosc, product.getProductName());
		}

	}

}
