package przyklady;

import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import sklep.model.Product;

public class Odczyt2_Petla {

	public static void main(String[] args) {
		Scanner scanner = null;
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			scanner = new Scanner(System.in);
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();
			
			while(true) {
				System.out.print("\nPodaj id produktu: ");
				int productId = scanner.nextInt();
				if(productId == 0) break;
				
				Product product = em.find(Product.class, productId);
				if(product == null) {
					System.out.println("Nie ma takiego produktu");
					continue;
				}
				System.out.println("Odczytany produkt: " + product);
				System.out.println(product.getProductName() + " za cenę " + product.getPrice());
				if(product.getDescription() != null) {
					System.out.println(product.getDescription());
				}
			}
		} finally {
			if(em != null) em.close();
			if(emf != null) emf.close();
			if(scanner != null) scanner.close();
		}
	}

}
