DROP TABLE IF EXISTS order_products;
DROP TABLE IF EXISTS orders;
DROP TABLE IF EXISTS customers;
DROP TABLE IF EXISTS products;

CREATE TABLE products (
	product_id SERIAL PRIMARY KEY,
	product_name VARCHAR(100) NOT NULL,
	price NUMERIC(10, 2) NOT NULL, -- wartości do 99999999.99
	vat NUMERIC(2, 2), -- wartości do 0.99
	description TEXT
);
-- w Oraclu nazwy tych typów to: VARCHAR2, NUMBER, CLOB

CREATE TABLE customers (
	-- w tej tabeli nie ma klucza numerycznego, tylko kluczem głównym będzie email klienta
	customer_email VARCHAR(255) PRIMARY KEY,
	customer_name VARCHAR(255) NOT NULL,
	phone_number VARCHAR(20),
    address VARCHAR(200),
    postal_code CHAR(6),
    city VARCHAR(100)
);

CREATE TABLE orders (
	order_id SERIAL PRIMARY KEY,
	customer_email VARCHAR(255) NOT NULL REFERENCES customers(customer_email),
	status VARCHAR(50) DEFAULT 'NEW' NOT NULL,
	order_date TIMESTAMP DEFAULT current_timestamp,
    delivery_date DATE
);

-- Realizacja związku wiele do wielu.
-- Akurat w tym przypadku są dodatkowe atrybuty, które trzeba tu wpisać.
CREATE TABLE order_products (
	order_id INTEGER NOT NULL REFERENCES orders(order_id),
	product_id INTEGER NOT NULL REFERENCES products(product_id),
	quantity INTEGER DEFAULT 1 NOT NULL,
	PRIMARY KEY (order_id, product_id)
);


INSERT INTO products(product_name, price, vat, description)
VALUES('pralka', 2500, 0.23, 'Pralka szybka i oszczędna');

INSERT INTO products(product_name, price)
VALUES('odkurzacz', 500);

INSERT INTO products
VALUES(DEFAULT, 'suszarka', 1200, 0.23, 'Szuszy, że hej');


INSERT INTO customers
VALUES('ala@kowalska.pl', 'Ala Kowalska', '123123123', 'Jasna 14/16a', '01-234', 'Warszawa');


INSERT INTO orders (customer_email, status, order_date, delivery_date)
VALUES ('ala@kowalska.pl', 'DELIVERED', '2022-03-04 13:30:05', '2022-03-08');

INSERT INTO orders (customer_email)
VALUES ('ala@kowalska.pl');

INSERT INTO order_products VALUES(1, 1, 2); -- Ala zamówiła dwie pralki
INSERT INTO order_products VALUES(1, 2, 5); -- W tym samym zamówieniu jest 5 odkurzaczy
INSERT INTO order_products VALUES(2, 1, 1); -- W zamówineiu nr 2 jest jedna pralka


SELECT * FROM products;

SELECT * FROM orders FULL JOIN customers USING(customer_email);

