package formularze;

import static org.apache.commons.lang3.ObjectUtils.allNotNull;
import static org.apache.commons.lang3.StringUtils.trimToNull;
import static org.apache.commons.lang3.math.NumberUtils.createInteger;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator_lang2")
public class Kalkulator_ApacheLang2 extends HttpServlet {
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Integer liczba1 = createInteger(trimToNull(request.getParameter("liczba1")));
		Integer liczba2 = createInteger(trimToNull(request.getParameter("liczba2")));
		String operacja = request.getParameter("operacja");
		
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Kalkulator</title>");
		out.println("</head>");
		out.println("<body>");
		out.println("<form style='border:2px solid green; padding: 1em; margin: 2em 0'>");
		out.println("<input type='number' name='liczba1'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input type='number' name='liczba2'>");
		out.println("<button>Oblicz</button>");
		out.println("</form>");
		
		if(allNotNull(liczba1, liczba2, operacja)) {
			int wynik = oblicz(liczba1, liczba2, operacja);
			out.println("<div>Działanie: " + liczba1 + " " + operacja + " " + liczba2 + "</div>");
			out.println("<div>Wynik: " + wynik + "</div>");
		}
		
		out.println("</body>");
		out.println("</html>");
	}

	private int oblicz(int liczba1, int liczba2, String operacja) {
		return switch (operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			default -> throw new IllegalArgumentException("Unexpected value: " + operacja);
		};
	}

}
