package przyklady;

import java.math.BigDecimal;
import java.util.List;
import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class Parametry {

	public static void main(String[] args) {
		// JPQL - Java (Jakarta) Persistence Query Language
		
		EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("sklep");
            em = emf.createEntityManager();
            Scanner scanner = new Scanner(System.in);
            
            System.out.print("Podaj cenę minimalną: ");
            BigDecimal min = scanner.nextBigDecimal();
            System.out.print("Podaj cenę maksymalną: ");
            BigDecimal max = scanner.nextBigDecimal();
            
            TypedQuery<Product> query = em.createQuery(
            		"SELECT p FROM Product p WHERE p.price BETWEEN :minimum AND :maximum ORDER BY p.price DESC", Product.class);
            query.setParameter("minimum", min);
            query.setParameter("maximum", max);
            List<Product> products = query.getResultList();
            for(Product product : products) {
				// System.out.println(product);
				System.out.println(product.getProductName() + " za cenę " + product.getPrice());
			}
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            if(em != null)
                em.close();
            if(emf != null)
                emf.close();
        }
	}

}
