package com.example.demo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.stereotype.Component;

/* LogikaKalkulatora jest przykładem "komponentu".
 * Podczas startu aplikacji Spring tworzy jeden obiekt tej klasy (tzw. singleton) i zapamiętuje go jako "bean".
 * W starszych wersjach Springa tego typu klasy należało zadeklarować w pliku beans.xml.
 * Obecnie używa się raczej adnotacji. Takie działanie mają adnotacje: @Component, @Service, @Repository, @Controller.
 * 
 * Inny sposób tworzenia beanów/kompomentów: klasa fabryczna z metodami oznaczonymi @Bean (będą inne przykłady).
 */
@Component
public class LogikaKalkulatoraImpl implements LogikaKalkulatora {
	private final List<String> historiaDzialan = Collections.synchronizedList(new ArrayList<>());
	
	@Override
	public long oblicz(long liczba1, long liczba2, String operacja) {
		long wynik = switch(operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			default  -> 0L;
		};
		historiaDzialan.add(String.format("%d %s %d = %d", liczba1, operacja, liczba2, wynik));
		return wynik;
	}
	
	@Override
	public List<String> getHistoriaDzialan() {
		return Collections.unmodifiableList(historiaDzialan);
	}
}
