package com.example.demo;

import java.util.List;

// @Component("inna") i potem za pomocą Qualifier wskazać w miejscu użycia (podczas wstrzykiwania)
// albo można za pomocą @Primary wskazać, że teraz ten komponent ma być wybrany
public class InnaLogika implements LogikaKalkulatora {
	@Override
	public long oblicz(long liczba1, long liczba2, String operacja) {
		long wynik = switch(operacja) {
			case "+" -> liczba1 + liczba2 + 1000;
			case "-" -> liczba1 - liczba2 + 1000;
			case "*" -> liczba1 * liczba2 + 1000;
			case "/" -> liczba1 / liczba2 + 1000;
			default  -> 0L;
		};
		return wynik;
	}
	
	@Override
	public List<String> getHistoriaDzialan() {
		return List.of("Ala", "Ola", "Ela");
	}
}
