package sklep.basket;

import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;

@WebListener
public class BasketInitialization implements HttpSessionListener {

	public void sessionCreated(HttpSessionEvent se) {
		HttpSession session = se.getSession();
		session.setMaxInactiveInterval(30); // sesja wygasa po pół minuty - tylko na potrzeby zajęć
		session.setAttribute("basket", new Basket());
		System.out.println("Początek sesji " + session.getId());
	}

	public void sessionDestroyed(HttpSessionEvent se) {
		System.out.println("Koniec sesji " + se.getSession().getId());
	}

}
