--
-- PostgreSQL database dump
--

-- Dumped from database version 14.7
-- Dumped by pg_dump version 15.2

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: public; Type: SCHEMA; Schema: -; Owner: postgres
--

-- *not* creating schema, since initdb creates it


ALTER SCHEMA public OWNER TO postgres;

--
-- Name: order_status; Type: TYPE; Schema: public; Owner: kurs
--

CREATE TYPE public.order_status AS ENUM (
    'NEW',
    'CONFIRMED',
    'PAID',
    'SHIPPED',
    'DELIVERED',
    'CLOSED',
    'RETURNED'
);


ALTER TYPE public.order_status OWNER TO kurs;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: customers; Type: TABLE; Schema: public; Owner: kurs
--

CREATE TABLE public.customers (
    customer_email character varying(255) NOT NULL,
    customer_name character varying(255) NOT NULL,
    phone_number character varying(20),
    address character varying(200),
    postal_code character(6),
    city character varying(100)
);


ALTER TABLE public.customers OWNER TO kurs;

--
-- Name: order_products; Type: TABLE; Schema: public; Owner: kurs
--

CREATE TABLE public.order_products (
    order_id integer NOT NULL,
    product_id integer NOT NULL,
    quantity integer DEFAULT 1 NOT NULL,
    actual_price numeric(10,2),
    actual_vat numeric(2,2),
    CONSTRAINT order_products_quantity_check CHECK ((quantity > 0))
);


ALTER TABLE public.order_products OWNER TO kurs;

--
-- Name: orders_seq; Type: SEQUENCE; Schema: public; Owner: kurs
--

CREATE SEQUENCE public.orders_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orders_seq OWNER TO kurs;

--
-- Name: orders; Type: TABLE; Schema: public; Owner: kurs
--

CREATE TABLE public.orders (
    order_id integer DEFAULT nextval('public.orders_seq'::regclass) NOT NULL,
    customer_email character varying(255) NOT NULL,
    status public.order_status DEFAULT 'NEW'::public.order_status NOT NULL,
    order_date timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    delivery_date date,
    CONSTRAINT orders_check CHECK ((delivery_date >= order_date))
);


ALTER TABLE public.orders OWNER TO kurs;

--
-- Name: products_seq; Type: SEQUENCE; Schema: public; Owner: kurs
--

CREATE SEQUENCE public.products_seq
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_seq OWNER TO kurs;

--
-- Name: products; Type: TABLE; Schema: public; Owner: kurs
--

CREATE TABLE public.products (
    product_id integer DEFAULT nextval('public.products_seq'::regclass) NOT NULL,
    product_name character varying(100) NOT NULL,
    price numeric(10,2) NOT NULL,
    vat numeric(2,2),
    description text,
    CONSTRAINT products_price_check CHECK ((price > (0)::numeric)),
    CONSTRAINT products_product_name_check CHECK ((length((product_name)::text) > 0)),
    CONSTRAINT products_vat_check CHECK ((vat >= (0)::numeric))
);


ALTER TABLE public.products OWNER TO kurs;

--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: kurs
--

COPY public.customers (customer_email, customer_name, phone_number, address, postal_code, city) FROM stdin;
ala@example.com	Ala Kowalska	123123123	Jasna 14/16	01-234	Warszawa
ola@example.com	Ola Malinowska	321321321	Ciemna 133	99-999	Pcim
\.


--
-- Data for Name: order_products; Type: TABLE DATA; Schema: public; Owner: kurs
--

COPY public.order_products (order_id, product_id, quantity, actual_price, actual_vat) FROM stdin;
1	1	1	2900.00	0.23
1	2	3	2400.00	0.23
2	2	1	800.00	0.23
3	4	1	2200.00	0.23
3	3	1	300.00	0.23
3	5	1	1000.00	0.23
\.


--
-- Data for Name: orders; Type: TABLE DATA; Schema: public; Owner: kurs
--

COPY public.orders (order_id, customer_email, status, order_date, delivery_date) FROM stdin;
1	ala@example.com	PAID	2021-11-20 12:30:00	\N
2	ola@example.com	SHIPPED	2021-11-18 10:00:00	2021-12-01
3	ala@example.com	NEW	2023-04-06 14:25:01.939538	\N
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: public; Owner: kurs
--

COPY public.products (product_id, product_name, price, vat, description) FROM stdin;
1	pralka	2900.00	0.23	Pralka szybkoobrotowa
2	odkurzacz	800.00	0.23	Odkurzacz automatyczny
3	telewizor 55"	3300.00	0.23	Telewizor 55 cali 4K
4	telewizor 40"	2200.00	0.23	Telewizor 40 Full HD
5	myszka gejmerska	444.00	0.23	\N
\.


--
-- Name: orders_seq; Type: SEQUENCE SET; Schema: public; Owner: kurs
--

SELECT pg_catalog.setval('public.orders_seq', 10, false);


--
-- Name: products_seq; Type: SEQUENCE SET; Schema: public; Owner: kurs
--

SELECT pg_catalog.setval('public.products_seq', 10, false);


--
-- Name: customers customers_pkey; Type: CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.customers
    ADD CONSTRAINT customers_pkey PRIMARY KEY (customer_email);


--
-- Name: order_products order_products_pkey; Type: CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.order_products
    ADD CONSTRAINT order_products_pkey PRIMARY KEY (order_id, product_id);


--
-- Name: orders orders_pkey; Type: CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.orders
    ADD CONSTRAINT orders_pkey PRIMARY KEY (order_id);


--
-- Name: products products_pk; Type: CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.products
    ADD CONSTRAINT products_pk PRIMARY KEY (product_id);


--
-- Name: order_products order_products_order_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.order_products
    ADD CONSTRAINT order_products_order_id_fkey FOREIGN KEY (order_id) REFERENCES public.orders(order_id);


--
-- Name: order_products order_products_product_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.order_products
    ADD CONSTRAINT order_products_product_id_fkey FOREIGN KEY (product_id) REFERENCES public.products(product_id);


--
-- Name: orders orders_customer_email_fkey; Type: FK CONSTRAINT; Schema: public; Owner: kurs
--

ALTER TABLE ONLY public.orders
    ADD CONSTRAINT orders_customer_email_fkey FOREIGN KEY (customer_email) REFERENCES public.customers(customer_email);


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE USAGE ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

