<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%-- W wersji JSTL 3.0 (Jakarta 10) uri="jakarta.tags.core" --%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Przykład JSP</title>
</head>
<body>
<h1>Przykład JSP 2</h1>

<%-- Wpisując w dowolne miejsce treści znacznik ${WYRAŻENIE} powodujemy, że WYRAŻENIE zostanie obliczone
a wynik trafi do treści.
WYRAŻENIA, które można wpisywać, to tzw. "Expression Language", "EL".
--%>

<p>Wynik działania: ${2 + 3 * 4}.</p>
<p>Parametr imie: ${param.imie}.</p>

<%-- Głównym zastosowaniem EL jest dostęp do obiektów nazywanych "beans".
Te obiekty mogą być wstępnie utworzone przez aplikację, albo mogą być tworzone w samym skrypcie:
--%>
<jsp:useBean id="obiekt" class="beans.PrzykladowyBean"/>
<p>Obiekt: ${obiekt}</p>
<p>Napis: ${obiekt.napis}</p>

<%-- Wypisanie całego obiektu jest realizowane poprzez wywołanie metody toString(),
a dostęp do pola w obiekcie poprzez wywołanie gettera.
${obiekt.napis} jest tłumaczone na obiekt.getNapis() --%>

<%-- Zmiana wartości poprzez wywołanie settera: --%>
<jsp:setProperty name="obiekt" property="napis" value="Ola ma psa"/>
<p>Napis po zmianie: ${obiekt.napis}</p>

<ul>
<li>cały DateTime: ${obiekt.currentTime}</li>
<li>rok: ${obiekt.currentTime.year}</li>
<li>dzień roku: ${obiekt.currentTime.dayOfYear}</li>
<li>sekunda: ${obiekt.currentTime.second}</li>
</ul>

<%-- Przykładowe użycia tagów z biblioteki JSTL Core --%>
<%-- Typowym zastosowaniem forEach jest przeglądanie elementów kolekcji,
     np. wyników zapytania bazodanowego. Tutaj coś prostszego: --%>
<ol>
<c:forEach var="miasto" items="Warszawa,Kraków,Wrocław,Gdańsk">
	<li>${miasto}</li>
</c:forEach>
</ol>

<c:if test="${not empty param.imie}">
	<p>Witaj ${param.imie}</p>
	<jsp:setProperty name="obiekt" property="napis" value="${param.imie} ma psa"/>
	<p>Napis po zmianie: ${obiekt.napis}</p>
</c:if>

</body>
</html>
