<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@page import="java.time.LocalTime"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Przykład JSP</title>
</head>
<body>
<h1>Przykład JSP</h1>
<p>Zwykły HTML jest po prostu wysyłany do klienta.</p>

<%-- To jest komentarz JSP. Jego treść nie zostanie wysłana do klienta. --%>
<!-- To jest komentarz HTML. Jego treść zostanie wysłana do klienta, ale przeglądarka jej nie wyświetli. -->

<%-- Tutaj widzimy podstawowe rozumienie czym jest JSP (Java/Jakarta Server Pages):
Pisanie HTML ze wstawkami Javy. Uwaga, to jest najstarszy styl użycia JSP.
W następnym przykładzie zobaczycie podejście "bardziej nowoczesne".
 --%>

<%-- Zasadniczo w JSP piszemy tagi HMTL i treści, które mają być wysłane w odpowiedzi do klienta. --%>
<%-- Natomiast wstawiając "skryptlet", możemy wykonać fragment kodu Javy.
Są tam dostępne "implicit objects", np. request, response, out - jak w serwletach.
<% ... %> zwykły blok kodu
 --%>
<%
int x = 12 + 13;
out.println("a to wypisała Java, x = " + x);
System.out.println("To wypisało JSP na konsolę.");
%>

<%-- <%= wyrażenie %> - wstawienie wartości --%>
<p>Wartość zmiennej x wynosi <%= x %>, a bieżący czas to <%= LocalTime.now() %>.</p>

<%-- <%! deklaracja z poziomu klasy %> - pozwala deklarować pola i metody w klasie serwletu --%>

<%! static int licznik = 0; %>
<%!
String akuku() {
	return "akuku, teraz licznik ma wartość " + licznik;
}
%>

<p>Wartość licznika: <%= ++licznik %></p>
<p>Wynik metody: <%= akuku() %></p>
</body>
</html>
