package formularze;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/rozmowa")
public class Rozmowa extends HttpServlet {
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String imie = request.getParameter("imie");
		String wiekStr = request.getParameter("wiek");
		int wiek;
		try {
			wiek = Integer.parseInt(wiekStr);
		} catch (Exception e) {
			wiek = 0;
		}
		
		System.out.println("Rozmowa.doGet(), imie=" + imie);
		
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Rozmowa serwletowa</title>");
		out.println("</head>");
		out.println("<body>");
		out.println("<form style='border:2px solid green; padding: 1em; margin: 2em 0'>");
		out.println("<label for='imie'>Jak masz na imię?</label>");
		out.println("<input type='text' name='imie'>");
		out.println("<br/>");
		out.println("<label for='wiek'>Ile masz lat?</label>");
		out.println("<input type='number' name='wiek'>");
		out.println("<br/>");
		out.println("<button>Wyślij</button>");
		out.println("</form>");
		
		if(imie != null) {
			out.println("<div style='border:2px solid blue; padding: 1em; margin: 2em 0'>");
			out.println("<p>Witaj " + imie + "</p>");
			if(wiek >= 18) {
				out.println("<p>Chodź na piwo</p>");				
			}
			out.println("</div>");
		}
		
		out.println("</body>");
		out.println("</html>");
	}

}
