package formularze;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator")
public class Kalkulator extends HttpServlet {
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String parametr1 = request.getParameter("liczba1");
		String parametr2 = request.getParameter("liczba2");
		String operacja = request.getParameter("operacja");
		
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Kalkulator</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<form>");
		out.println("<input type='number' name='liczba1'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input type='number' name='liczba2'>");
		out.println("<button>Oblicz</button>");
		out.println("</form>");
		
		if(parametr1 != null && !parametr1.isBlank()
				&& parametr2 != null && !parametr2.isBlank()
				&& operacja != null && !operacja.isBlank()) {
			int liczba1 = Integer.parseInt(parametr1);
			int liczba2 = Integer.parseInt(parametr2);
			int wynik = oblicz(liczba1, liczba2, operacja);
			out.println("<div>Działanie: " + liczba1 + " " + operacja + " " + liczba2 + "</div>");
			out.println("<div>Wynik: " + wynik + "</div>");
		}
		
		out.println("</body>");
		out.println("</html>");
	}

	private int oblicz(int liczba1, int liczba2, String operacja) {
		return switch (operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			default -> throw new IllegalArgumentException("Unexpected value: " + operacja);
		};
	}

}
