package bazy.podstawy;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ProsteZapytanie1 {
	// JDBC - Java Database Connectivity
	// Programista w swoim kodzie używa ogólnych interfejsów i operacji:
	// Connection, PreparedStatement, ResultSet, executeQuery...
	// natomiast ich implementacje są dostarczane w formie "sterowników" właściwych dla poszczególnych rodzajów baz danych.
	public static void main(String[] args) {
		try {
			// Koncepcyjnie rzecz biorąc, robimy coś takiego, ale zapisuje się to ogólnie...
			// Connection c = new PGConnection(...);
			Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/hr", "kurs", "abc123");
			System.out.println("Udało się połączyć. Połączenie: " + c);
			
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees");
			
			ResultSet rs = stmt.executeQuery();
			System.out.println("Mam wyniki: " + rs);
			
			while(rs.next()) {
				int id = rs.getInt(1); // kolumna wynikowa nr 1 - numeracja od 1!
				String imie = rs.getString(2); // kolumna nr 2
				// ale wartości można też odczytywać podając nazwę kolumny:
				String nazwisko = rs.getString("last_name");
				String job = rs.getString("job_id");
				BigDecimal pensja = rs.getBigDecimal("salary");
				java.sql.Date data = rs.getDate("hire_date");
				System.out.printf("%d. %s %s (%s) zatr. %s zarabia %s\n", id, imie, nazwisko, job, data, pensja);
			}
			c.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}

	}

}
