package bazy.podstawy;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

import javax.swing.JOptionPane;

public class Parametry1 {
	/* Rozwiązanie 1:
	   Z bazy odczytujemy wszystkie rekordy, a po stronie w Javy, za pomocą equals filtrujemy rekordy i wyświeltlamy tylko te, które spełniają warunek.
	   
	   Problem: niska wydajność.
	   Baza musi odczytać wszystkie rekordy z dysku (nawet, gdyby były zdefinioane indeksy),
	   wszystkie dane są transferowane przez sieć,
	   wszystkie dane są przeglądane przez Javę, co obciąża aplikację kliencką.
	*/
	
	public static void main(String[] args) {
		String szukany_job = JOptionPane.showInputDialog("Podaj kod stanowiska");
		
		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/hr", "kurs", "abc123");
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees");
			ResultSet rs = stmt.executeQuery()) {
			
			while(rs.next()) {
				int id = rs.getInt(1);
				String imie = rs.getString("first_name");
				String nazwisko = rs.getString("last_name");
				String job = rs.getString("job_id");
				BigDecimal pensja = rs.getBigDecimal("salary");
				java.sql.Date data = rs.getDate("hire_date");
				if(Objects.equals(job, szukany_job)) {
					System.out.printf("%d. %s %s (%s) zatr. %s zarabia %s\n", id, imie, nazwisko, job, data, pensja);
				}
			}
			
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
