package konto;

public class Przeploty {

	public static void main(String[] args) {
		final int KWOTA = 10;
		final int ILE_RAZY = 100_000;
		
		Konto konto = new Konto(1, "Ala", KWOTA * ILE_RAZY);
		System.out.println("Stan początkowy: " + konto.getSaldo());
		
		Thread wplacacz = new Thread(() -> {
			for(int i = 0; i < ILE_RAZY; i++) {
				konto.wplata(KWOTA);
			}
		});
		
		Thread wyplacacz = new Thread(() -> {
			try {
				for(int i = 0; i < ILE_RAZY; i++) {
					konto.wyplata(KWOTA);
				}
			} catch (BrakSrodkow e) {
				e.printStackTrace();
			}
		});

		System.out.println("Startujemy wątki...");
		wplacacz.start();
		wyplacacz.start();
		
		System.out.println("Czekam na zakończenie wątków...");
		try {
			wplacacz.join();
			wyplacacz.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		System.out.println("...gotowe");
		System.out.println("Stan końcowy: " + konto.getSaldo());
	}

}
