package konto;

public class Konto {
	private final int numer;
	private final String wlasciciel;
	private int saldo;
	
	public Konto(int numer, String wlasciciel, int saldo) {
		this.numer = numer;
		this.wlasciciel = wlasciciel;
		this.saldo = saldo;
	}
	
	public Konto(int numer, String wlasciciel) {
		this(numer, wlasciciel, 0);
	}

	public int getNumer() {
		return numer;
	}

	public String getWlasciciel() {
		return wlasciciel;
	}

	public int getSaldo() {
		return saldo;
	}

	@Override
	public String toString() {
		return "Konto nr " + numer + ", wł. " + wlasciciel + ", saldo " + saldo;
	}

	public synchronized void wplata(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota w metodzie wplata");
		}
		saldo += kwota;
		notify();
		// budzi jeden z czekających wątków
	}

	// W tej wersji metoda w razie braku środków wyrzuca wyjątek
	public synchronized void wyplata(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota w metodzie wyplata");
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Brak środków na koncie nr " + numer);
		}
		saldo -= kwota;
	}
	
	// W tej wersji metoda w razie braku środków czeka aż pieniądze zostaną wpłacone
	public synchronized void wyplataCzekaj(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Niedodatnia kwota w metodzie wyplata");
		}
		try {
			while(kwota > saldo) {
				wait();
			}
			saldo -= kwota;
			notify();
			// budzenie kaskadowe: jeśli dla jednego wątku wystarczyło, to budzony jest następny
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
}
