package com.example.demo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/kalkulator")
public class KalkulatorController {
	@Autowired
	private LogikaKalkulatora logikaKalkulatora;

	@GetMapping
	public String kalkulatorGet() {
		return "kalkulator.html";
	}
	
	@PostMapping
	public String kalkulatorPost(Long liczba1, Long liczba2, String operacja, Model model) {
		if(liczba1 != null && liczba2 != null && operacja != null) {
			Long wynik = logikaKalkulatora.oblicz(liczba1, liczba2, operacja);
			model.addAttribute("wynik", wynik);
			model.addAttribute("historia", logikaKalkulatora.getHistoriaDzialan());
		}
		return "kalkulator.html";
	}
	
}
