package formularze;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator_post")
public class KalkulatorPost extends HttpServlet {
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// w tej wersji GET służy tylko do wyświetlenia pustego formularza
		PrintWriter out = poczatekStrony(response);
		wydrukujFormularz(out);
		koniecStrony(out);
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// doPost obsługuje przysłane dane z formularza
		PrintWriter out = poczatekStrony(response);
		wydrukujFormularz(out);

		try {
			String parametr1 = request.getParameter("liczba1");
			String parametr2 = request.getParameter("liczba2");
			String operacja = request.getParameter("operacja");
			
			int liczba1 = Integer.parseInt(parametr1);
			int liczba2 = Integer.parseInt(parametr2);
			int wynik = oblicz(liczba1, liczba2, operacja);
			// out.println("<div class='wynik'>" + liczba1 + " " + operacja + " " + liczba2 + " = <strong>" + wynik + "<strong></div>");
			out.printf("<div class='wynik'>%s %s %s = <strong>%s</strong></div>\n",
					liczba1, operacja, liczba2, wynik);
		} catch (Exception e) {
			out.println("<div class='error'>Błąd: " + e + "</div>");
		}
		
		koniecStrony(out);
	}

	private void koniecStrony(PrintWriter out) {
		out.println("</body>");
		out.println("</html>");
	}

	private PrintWriter poczatekStrony(HttpServletResponse response) throws IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Kalkulator</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		return out;
	}

	private void wydrukujFormularz(PrintWriter out) {
		out.println("<form method='post'>");
		out.println("<input type='number' name='liczba1'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");
		out.println("<input type='number' name='liczba2'>");
		out.println("<button>Oblicz</button>");
		out.println("</form>");
	}
	
	private int oblicz(int liczba1, int liczba2, String operacja) {
		return switch (operacja) {
			case "+" -> liczba1 + liczba2;
			case "-" -> liczba1 - liczba2;
			case "*" -> liczba1 * liczba2;
			case "/" -> liczba1 / liczba2;
			default -> throw new IllegalArgumentException("Unexpected value: " + operacja);
		};
	}

}
