package watki.podstawy;

public class Watki1 {

	private static final int ILE_RAZY = 1000;

	public static void main(String[] args) {
		System.out.println("Początek main");
		
		Runnable przepisA = new Runnable() {
			public void run() {
				// Tutaj piszemy co ma robić wątek
				System.out.println("A start");
				for(int i = 1; i <= ILE_RAZY; i++) {
					System.out.println("A " + i);
				}
				System.out.println("A koniec");
			}
		};
		
		// Obiekt wątku tworzymy w oparciu o "przepis" mówiący, co wątek ma robić:
		Thread watekA = new Thread(przepisA);
		
		// Można zapisać to bez dodatkowej zmiennej:
		Thread watekB = new Thread(new Runnable() {
			public void run() {
				System.out.println("B start");
				for(int i = 1; i <= ILE_RAZY; i++) {
					System.out.println("B " + i);
				}
				System.out.println("B koniec");
			}
		});
		
		Thread watekC = new Thread(() -> {
			System.out.println("C start");
			for(int i = 1; i <= ILE_RAZY; i++) {
				System.out.println("C " + i);
			}
			System.out.println("C koniec");
		});
		
		System.out.println("Wątki utworzone. Uruchamiam je...");
		watekA.start();
		watekB.start();
		watekC.start();
		
// Gdyby teraz main miał poczekać, aż wątki się zakończą, to:
//		try {
//			System.out.println("main czeka na koniec wątków");
//			watekA.join();
//			watekB.join();
//			watekC.join();
//			System.out.println("main się doczekał");
//		} catch (InterruptedException e) {
//			// czysta teoria: tego wyjątku tu nie będzie; byłby, gdyby ktoś przerwał wątem main za pomocą interrupt()
//			e.printStackTrace();
//		}
		
		System.out.println("Koniec main");
	}

}
